/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.bronzedungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeBossRoom;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonPiece;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonRoom;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonSurfaceRuins;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeProcessorSettings;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeTunnel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5497;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import org.jetbrains.annotations.Nullable;

public class BronzeDungeonBuilder {
    public static final Map<String, class_6005.class_6006<RoomProvider<?>>> ROOM_OPTIONS_BUILDER = Map.ofEntries(Map.entry("boss_room", new class_6005.class_6006()), Map.entry("chest_room", new class_6005.class_6006()), Map.entry("end_corridor", new class_6005.class_6006()), Map.entry("entrance", new class_6005.class_6006()), Map.entry("lobby", new class_6005.class_6006()), Map.entry("square_tunnel", new class_6005.class_6006()));
    private static Map<String, class_6005<RoomProvider<?>>> ROOM_OPTIONS;
    private final class_3195.class_7149 context;
    private final class_3485 manager;
    private final class_5819 random;
    private final BronzeProcessorSettings processors;
    private final int nodeWidth;
    private final int edgeWidth;
    private final int edgeLength;
    private final int maxSize;
    private final List<class_3443> nodes = new ArrayList<class_3443>();
    private final Map<class_3443, Map<class_2350, Connection>> edges = new HashMap<class_3443, Map<class_2350, Connection>>();

    public BronzeDungeonBuilder(class_3195.class_7149 context, int maxSize, BronzeProcessorSettings processors) {
        this.context = context;
        this.manager = context.comp_565();
        this.random = context.comp_566();
        this.processors = processors;
        class_2382 nodeSize = context.comp_565().method_15091(class_2960.method_60655((String)"aether", (String)"bronze_dungeon/chest_room")).method_15160();
        this.nodeWidth = nodeSize.method_10263();
        class_2382 edgeSize = context.comp_565().method_15091(class_2960.method_60655((String)"aether", (String)"bronze_dungeon/square_tunnel")).method_15160();
        this.edgeWidth = edgeSize.method_10263();
        this.edgeLength = edgeSize.method_10260();
        this.maxSize = Math.max(3, maxSize);
    }

    public void initializeDungeon(class_2338 startPos, class_3195.class_7149 genContext, class_6626 builder) {
        ROOM_OPTIONS = ROOM_OPTIONS_BUILDER.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((class_6005.class_6006)e.getValue()).method_34974()));
        class_3499 bossTemplate = this.context.comp_565().method_15091(class_2960.method_60655((String)"aether", (String)"bronze_dungeon/boss_room"));
        class_2470 rotation = this.getBossRoomRotation(startPos, startPos.method_10081(bossTemplate.method_15160()));
        if (rotation == null) {
            return;
        }
        BronzeDungeonPiece bossRoom = this.chooseRoom("boss_room", startPos, rotation, this.processors.bossSettings());
        class_2350 direction = bossRoom.method_14934();
        if (direction != null) {
            class_2338 pos = BlockLogicUtil.tunnelFromEvenSquareRoom(bossRoom.method_14935().method_19311(0, 2, 0), direction, this.edgeWidth);
            BronzeDungeonPiece hallway = this.chooseRoom("square_tunnel", pos, bossRoom.method_16888(), this.processors.roomSettings());
            pos = BlockLogicUtil.tunnelFromEvenSquareRoom(hallway.method_14935(), direction, this.nodeWidth);
            BronzeDungeonPiece defaultRoom = this.chooseRoom("chest_room", pos, hallway.method_16888(), this.processors.roomSettings());
            this.nodes.add((class_3443)bossRoom);
            this.nodes.add((class_3443)defaultRoom);
            new Connection(this, (class_3443)bossRoom, (class_3443)defaultRoom, (class_3443)hallway, direction);
            class_1923 chunkPos = genContext.comp_568();
            for (int i = 2; i < this.maxSize - 1; ++i) {
                this.propagateRooms((class_3443)defaultRoom, chunkPos, false);
            }
            this.propagateRooms((class_3443)defaultRoom, chunkPos, true);
            class_3443 lobby = this.nodes.getLast();
            this.buildEndTunnel(lobby, startPos);
            this.buildSurfaceTunnel(genContext.comp_569(), genContext.comp_562(), genContext.comp_564());
            this.populatePiecesBuilder(builder);
        }
    }

    private boolean propagateRooms(class_3443 currentNode, class_1923 chunkPos, boolean placeLobby) {
        class_2470 rotation = currentNode.method_16888();
        ArrayList<class_2470> rotations = new ArrayList<class_2470>(3);
        rotations.add(rotation.method_10501(class_2470.field_11465));
        rotations.add(rotation);
        rotations.add(rotation.method_10501(class_2470.field_11463));
        String roomName = placeLobby ? "lobby" : "chest_room";
        for (int i = 3; i > 0; --i) {
            boolean flag;
            rotation = (class_2470)rotations.remove(this.random.method_43048(i));
            class_2350 direction = rotation.method_10503(class_2350.field_11035);
            if (this.hasConnection(currentNode, direction)) {
                if (!this.propagateRooms(this.edges.get((Object)currentNode).get((Object)direction).end, chunkPos, placeLobby)) continue;
                return true;
            }
            class_2338 pos = BlockLogicUtil.tunnelFromEvenSquareRoom(currentNode.method_14935(), direction, this.edgeWidth);
            BronzeDungeonPiece hallway = this.chooseRoom("square_tunnel", pos, rotation, this.processors.roomSettings());
            pos = BlockLogicUtil.tunnelFromEvenSquareRoom(hallway.method_14935(), direction, this.nodeWidth);
            BronzeDungeonPiece room = this.chooseRoom(roomName, pos, rotation, this.processors.roomSettings());
            class_3443 collisionPiece = class_3443.method_38702(this.nodes, (class_3341)room.method_14935());
            if (!this.isCloseToCenter(chunkPos, room.method_41625()) || !this.isCoveredAtPos(room.method_14935())) continue;
            if (collisionPiece == null) {
                new Connection(this, currentNode, (class_3443)room, (class_3443)hallway, direction);
                this.nodes.add((class_3443)room);
                return true;
            }
            if (collisionPiece instanceof BronzeBossRoom || (flag = this.edges.computeIfAbsent(collisionPiece, piece -> new HashMap()).values().stream().map(Connection::endPiece).anyMatch(piece -> piece == currentNode))) continue;
            new Connection(this, currentNode, (class_3443)room, (class_3443)hallway, direction);
        }
        return false;
    }

    private void buildEndTunnel(class_3443 lobby, class_2338 origin) {
        class_2470 rotation = lobby.method_16888();
        ArrayList<class_2470> rotations = new ArrayList<class_2470>(3);
        rotations.add(rotation.method_10501(class_2470.field_11465));
        rotations.add(rotation);
        rotations.add(rotation.method_10501(class_2470.field_11463));
        ArrayList<class_3443> longestTunnel = null;
        for (int i = 3; i > 0; --i) {
            class_2350 direction;
            ArrayList<class_3443> tunnel = new ArrayList<class_3443>();
            rotation = (class_2470)rotations.remove(this.random.method_43048(i));
            if (this.buildTunnelFromRoom(lobby, tunnel, rotation, direction = rotation.method_10503(class_2350.field_11035), origin)) {
                longestTunnel = tunnel;
                break;
            }
            if (longestTunnel != null && tunnel.size() <= longestTunnel.size()) continue;
            longestTunnel = tunnel;
        }
        this.nodes.addAll(longestTunnel);
    }

    @Nullable
    private class_3443 seekLastRoomNode(int minWidth) {
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            class_3443 piece = this.nodes.get(i);
            class_3341 box = piece.method_14935();
            if (box.method_35414() <= minWidth || box.method_14663() <= minWidth) continue;
            return piece;
        }
        return null;
    }

    private void buildSurfaceTunnel(class_5539 level, class_2794 chunkGenerator, class_7138 randomState) {
        int shrink = 3;
        class_3443 lobby = this.seekLastRoomNode(6);
        if (lobby == null) {
            return;
        }
        class_3341 lobbyBounds = lobby.method_14935();
        class_2338 entranceRoomCenter = lobbyBounds.method_22874();
        int topSurfaceY = chunkGenerator.method_18028(entranceRoomCenter.method_10263(), entranceRoomCenter.method_10260(), class_2902.class_2903.field_13195, level, randomState);
        int roomCeiling = lobbyBounds.method_35419() + 1;
        if (roomCeiling > topSurfaceY) {
            return;
        }
        int ruinsTopY = Math.max(roomCeiling, topSurfaceY + 4);
        int minX = lobbyBounds.method_35415() + 3;
        int minZ = lobbyBounds.method_35417() + 3;
        int maxX = lobbyBounds.method_35418() - 3;
        int maxZ = lobbyBounds.method_35420() - 3;
        class_3341 upwardsTunnelBox = new class_3341(Math.min(minX, maxX), roomCeiling, Math.min(minZ, maxZ), Math.max(minX, maxX), ruinsTopY, Math.max(minZ, maxZ));
        this.nodes.add(new BronzeDungeonSurfaceRuins(upwardsTunnelBox));
    }

    public boolean buildTunnelFromRoom(class_3443 connectedRoom, List<class_3443> list, class_2470 rotation, class_2350 direction, class_2338 origin) {
        class_2338 pos;
        class_3499 template = this.manager.method_15091(class_2960.method_60655((String)"aether", (String)"bronze_dungeon/entrance"));
        class_2338 startPos = BlockLogicUtil.tunnelFromEvenSquareRoom(connectedRoom.method_14935(), direction, template.method_15160().method_10263());
        BronzeDungeonPiece entrance = this.chooseRoom("entrance", startPos, rotation, this.processors.roomSettings());
        list.add((class_3443)entrance);
        startPos = startPos.method_10093(direction);
        int length = template.method_15160().method_10260();
        boolean noOverlap = false;
        boolean reachedAir = false;
        int i = 0;
        do {
            pos = startPos.method_10079(direction, i);
            BronzeDungeonPiece tunnel = this.chooseRoom("end_corridor", pos, rotation, this.processors.tunnelSettings());
            class_3443 col = null;
            for (class_3443 piece : this.nodes) {
                if (piece == null || piece == connectedRoom || !piece.method_14935().method_14657(tunnel.method_14935())) continue;
                col = piece;
                break;
            }
            if (col != null) break;
            noOverlap = true;
            list.add((class_3443)tunnel);
            connectedRoom = tunnel;
            i += length;
            if (!this.checkForAirAtPos(pos.method_10263(), pos.method_10264(), pos.method_10260()) || !this.checkForAirAtPos(pos.method_10263(), tunnel.method_14935().method_35419(), pos.method_10260())) continue;
            reachedAir = true;
            break;
        } while (Math.abs(origin.method_10263() - pos.method_10263()) < 100 && Math.abs(origin.method_10260() - pos.method_10260()) < 100);
        return noOverlap && reachedAir;
    }

    public BronzeDungeonPiece chooseRoom(String name, class_2338 pos, class_2470 rotation, class_6880<class_5497> processors) {
        Optional option;
        class_6005<RoomProvider<?>> list = ROOM_OPTIONS.get(name);
        if (list != null && (option = list.method_34973(this.random)).isPresent()) {
            return ((RoomProvider)option.get()).provide(this.manager, pos, rotation, processors);
        }
        return new BronzeDungeonRoom(this.manager, name, pos, rotation, processors);
    }

    public void populatePiecesBuilder(class_6626 builder) {
        class_3443 bossRoom = this.nodes.removeFirst();
        this.nodes.forEach(arg_0 -> ((class_6626)builder).method_35462(arg_0));
        this.edges.values().forEach(map -> map.values().forEach(connection -> builder.method_35462(connection.hallway)));
        builder.method_35462(bossRoom);
    }

    private boolean hasConnection(class_3443 node, class_2350 direction) {
        Map<class_2350, Connection> map = this.edges.get(node);
        return map != null && map.containsKey(direction);
    }

    private boolean checkForAirAtPos(int x, int y, int z) {
        class_4966 column = this.context.comp_562().method_26261(x, z, this.context.comp_569(), this.context.comp_564());
        return column.method_32892(y).method_26215();
    }

    private boolean isCloseToCenter(class_1923 chunkPos, class_2338 pos) {
        class_1923 currentChunk = new class_1923(pos);
        return chunkPos.method_24022(currentChunk) <= 3;
    }

    private boolean isCoveredAtPos(class_3341 room) {
        class_2794 chunkGenerator = this.context.comp_562();
        class_5539 heightAccessor = this.context.comp_569();
        class_7138 randomState = this.context.comp_564();
        int minX = room.method_35415() - 1;
        int minZ = room.method_35417() - 1;
        int maxX = room.method_35418() + 1;
        int maxZ = room.method_35420() + 1;
        class_4966[] columns = new class_4966[]{chunkGenerator.method_26261(minX, minZ, heightAccessor, randomState), chunkGenerator.method_26261(minX, maxZ, heightAccessor, randomState), chunkGenerator.method_26261(maxX, minZ, heightAccessor, randomState), chunkGenerator.method_26261(maxX, maxZ, heightAccessor, randomState)};
        return BronzeDungeonBuilder.isSolidInColumns(columns, room.method_35416() - 1, room.method_35419() + 1);
    }

    @Nullable
    private class_2470 getBossRoomRotation(class_2338 minPos, class_2338 maxPos) {
        class_3499 template = this.context.comp_565().method_15091(class_2960.method_60655((String)"aether", (String)"bronze_dungeon/chest_room"));
        class_2919 random = this.context.comp_566();
        class_3341 bossBox = new class_3341(minPos.method_10263(), minPos.method_10264(), minPos.method_10260(), maxPos.method_10263(), maxPos.method_10264(), maxPos.method_10260());
        for (class_2470 rotation : class_2470.method_16547((class_5819)random)) {
            class_2350 direction = rotation.method_10503(class_2350.field_11035);
            class_2338.class_2339 neighbor = BlockLogicUtil.tunnelFromEvenSquareRoom(bossBox, direction, this.nodeWidth).method_25503();
            if (!this.isCoveredAtPos(template.method_27267((class_2338)(neighbor = neighbor.method_10100(direction.method_10148() * (this.edgeLength + bossBox.method_35414()), 0, direction.method_10165() * (this.edgeLength + bossBox.method_14663()))), rotation, class_2338.field_10980, class_2415.field_11302))) continue;
            return rotation;
        }
        return null;
    }

    private static boolean isSolidInColumns(class_4966[] columns, int minY, int maxY) {
        for (class_4966 column : columns) {
            for (int y = minY; y <= maxY; ++y) {
                if (!column.method_32892(y).method_26215() && !column.method_32892(y).method_26164(AetherTags.Blocks.NON_BRONZE_DUNGEON_SPAWNABLE)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        ROOM_OPTIONS_BUILDER.get("boss_room").method_34975((manager, pos, rotation, processorList) -> new BronzeBossRoom(manager, "boss_room", pos, rotation, (class_6880<class_5497>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("chest_room").method_34975((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "chest_room", pos, rotation, (class_6880<class_5497>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("end_corridor").method_34975((manager, pos, rotation, processorList) -> new BronzeTunnel(manager, "end_corridor", pos, rotation, (class_6880<class_5497>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("entrance").method_34975((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "entrance", pos, rotation, (class_6880<class_5497>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("lobby").method_34975((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "lobby", pos, rotation, (class_6880<class_5497>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("square_tunnel").method_34975((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "square_tunnel", pos, rotation, (class_6880<class_5497>)processorList), 1);
    }

    private class Connection {
        public final class_3443 start;
        public final class_3443 end;
        public final class_3443 hallway;

        public Connection(BronzeDungeonBuilder bronzeDungeonBuilder, class_3443 start, class_3443 end, class_3443 hallway, class_2350 direction) {
            this.start = start;
            this.end = end;
            this.hallway = hallway;
            bronzeDungeonBuilder.edges.computeIfAbsent(start, piece -> new HashMap()).put(direction, this);
        }

        public class_3443 endPiece() {
            return this.end;
        }
    }

    @FunctionalInterface
    public static interface RoomProvider<T extends BronzeDungeonPiece> {
        public T provide(class_3485 var1, class_2338 var2, class_2470 var3, class_6880<class_5497> var4);
    }
}

